/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.block;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;

public class CraftBlockEntityState<T extends avj>
extends CraftBlockState {
    private final Class<T> tileEntityClass;
    private final T tileEntity;
    private T snapshot;
    private boolean isSnapshotInit = false;
    private final fy nbtSnapshot;

    protected void initSnapshotFromNbt() {
        if (!this.isSnapshotInit) {
            this.snapshot = this.nbtSnapshot != null ? avj.a((amu)this.tileEntity.D(), (fy)this.nbtSnapshot) : null;
            this.load(this.snapshot);
            this.isSnapshotInit = true;
        }
    }

    public CraftBlockEntityState(Block block, Class<T> tileEntityClass) {
        super(block);
        this.tileEntityClass = tileEntityClass;
        CraftWorld world = (CraftWorld)this.getWorld();
        this.tileEntity = (avj)tileEntityClass.cast(world.getTileEntityAt(this.getX(), this.getY(), this.getZ()));
        this.nbtSnapshot = this.tileEntity != null ? this.tileEntity.b(new fy()) : null;
    }

    public CraftBlockEntityState(Material material, T tileEntity) {
        super(material);
        this.tileEntityClass = tileEntity.getClass();
        this.tileEntity = tileEntity;
        this.nbtSnapshot = tileEntity != null ? tileEntity.b(new fy()) : null;
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        fy nbtTagCompound = tileEntity.b(new fy());
        avj snapshot = avj.a((amu)tileEntity.D(), (fy)nbtTagCompound);
        return (T)snapshot;
    }

    private void copyData(T from, T to) {
        et pos = to.w();
        fy nbtTagCompound = from.b(new fy());
        to.a(nbtTagCompound);
        to.a(pos);
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        this.initSnapshotFromNbt();
        return this.snapshot;
    }

    protected avj getTileEntityFromWorld() {
        this.requirePlaced();
        return ((CraftWorld)this.getWorld()).getTileEntityAt(this.getX(), this.getY(), this.getZ());
    }

    public fy getSnapshotNBT() {
        this.initSnapshotFromNbt();
        this.applyTo(this.snapshot);
        return this.snapshot.b(new fy());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        this.initSnapshotFromNbt();
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(avj tileEntity) {
        return this.tileEntityClass.isInstance(tileEntity);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        avj tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo((avj)this.tileEntityClass.cast(tile));
            tile.y_();
        }
        return result;
    }
}

